from crm.agency_cabinet.common.consts import ContractType, CalculatorServiceType
from crm.agency_cabinet.rewards.server.src.celery.tasks.calculator.predicts.synchronizer import \
    BasePredictsSynchronizer, BaseBusinessPredictsSynchronizer as BusinessPredictsSynchronizer


class BaseMediaPredictsSynchronizer(BasePredictsSynchronizer):
    service = CalculatorServiceType.media.value
    contract_type = ContractType.base.value

    INDEX_ID_TO_YT_COLUMN_MAP = {
        'early_payment': 'revenue',
        'revenue': 'revenue',
    }


class BaseVideoPredictsSynchronizer(BasePredictsSynchronizer):
    service = CalculatorServiceType.video.value
    contract_type = ContractType.base.value

    INDEX_ID_TO_YT_COLUMN_MAP = {
        'early_payment': 'revenue',
        'revenue': 'revenue',
        'outstream': 'outstream'
    }


class BaseZenPredictsSynchronizer(BasePredictsSynchronizer):
    service = CalculatorServiceType.zen.value
    contract_type = ContractType.base.value

    INDEX_ID_TO_YT_COLUMN_MAP = {
        'revenue': 'revenue',
        # 'early_payment': 'revenue',
    }


class BaseBusinessPredictsSynchronizer(BusinessPredictsSynchronizer):
    service = CalculatorServiceType.business.value
    contract_type = ContractType.base.value

    GRADE_META_INFO = {
        'D': {
            'threshold_start': 0
        },
        'C': {
            'threshold_start': 4000
        },
        'B': {
            'threshold_start': 20000
        },
        'A': {
            'threshold_start': 65000
        },
    }


class BaseDirectPredictsSynchronizer(BasePredictsSynchronizer):
    service = CalculatorServiceType.direct.value
    contract_type = ContractType.base.value

    INDEX_ID_TO_YT_COLUMN_MAP = {
        # 'direct': '',  TODO: ???
        'revenue': 'revenue',
        'early_payment': 'revenue',
        'rsya': 'predict_m_amt_rsya',
        'conversion_autostrategy': 'predict_q_amt_auto_Q3',
        'key_goals': 'predict_q_amt_goal_Q3',
        'metrica': 'predict_q_amt_metrika',
        'retargeting': 'predict_q_amt_retargeting'
    }
