import logging
from crm.agency_cabinet.rewards.server.src.celery.tasks.calculator.loader import BaseDataLoader, DataLoaderException


LOGGER = logging.getLogger('celery.tasks.calculator.predicts.loader')


class PredictLoaderException(DataLoaderException):
    pass


class BasePredictsLoader(BaseDataLoader):
    base_exception_class = PredictLoaderException

    COLUMNS = '''
        `dt` AS dt,
        `predict_amt` AS  revenue,
        `predict_amt_prev` as revenue_prev,
        `predict_q_amt_outstream_video` as outstream,
    '''  # TODO: revenue_new_clients???

    YQL_QUERY = '''
        use hahn;

        DECLARE $service_name AS String;
        DECLARE $predicts_table_path AS String;
        DECLARE $period_from AS String;
        DECLARE $period_to AS String;

        SELECT
            contract_id,
            AGGREGATE_LIST(
                AsStruct(
                    {}
                )
            ) AS indexes_and_grades


        FROM $predicts_table_path
        WHERE
            discount_name=$service_name
            AND dt<$period_to
            AND dt>=$period_from
        GROUP BY contract_id
        ;
    '''
