from .synchronizer import ProfMediaPredictsSynchronizer, ProfVideoPredictsSynchronizer, ProfZenPredictsSynchronizer, \
    ProfDirectPredictsSynchronizer, ProfBusinessPredictsSynchronizer
from crm.agency_cabinet.rewards.server.src.celery.tasks.calculator.predicts.loader import BasePredictsLoader


class ProfMediaPredictsLoader(BasePredictsLoader):
    service_name = 'Медийка'
    synchronizer_class = ProfMediaPredictsSynchronizer


class ProfVideoPredictsLoader(BasePredictsLoader):
    service_name = 'Видео'
    synchronizer_class = ProfVideoPredictsSynchronizer


class ProfZenPredictsLoader(BasePredictsLoader):
    service_name = 'Дзен'
    synchronizer_class = ProfZenPredictsSynchronizer


class ProfDirectPredictsLoader(BasePredictsLoader):
    COLUMNS = '''
        `dt` AS dt,
        `predict_amt` AS  revenue,
        `predict_m_amt_rsya_prof` as predict_m_amt_rsya,
        `predict_q_amt_auto_Q3` as predict_q_amt_auto_Q3,
        `predict_q_amt_goal_Q3` as predict_q_amt_goal_Q3,
        `predict_q_amt_metrika` as predict_q_amt_metrika,
        `predict_q_amt_video_cpc_Q3` as predict_q_amt_video_cpc_Q3,
        `predict_q_amt_smart_banner` as predict_q_amt_smart_banner,
        `predict_q_amt_rmp` as predict_q_amt_rmp,
        `predict_q_amt_retargeting` as predict_q_amt_retargeting,
        `predict_q_amt_k50` as predict_q_amt_k50,
        `predict_q_amt_product_gallery` as predict_q_amt_product_gallery,
        `predict_q_amt_search_autotargeting_not_uac` as predict_q_amt_search_autotargeting_not_uac,
        `predict_m_uniqd_prof_d_150k` as predict_m_uniqd_prof_d_150k,
        `predict_m_amt_prof_d_150k` as predict_m_amt_prof_d_150k,
        `predict_m_uniqd_prof_c_150k_800k` as predict_m_uniqd_prof_c_150k_800k,
        `predict_m_amt_prof_c_150k_800k` as predict_m_amt_prof_c_150k_800k,
        `predict_m_uniqd_prof_b_800k_5m` as predict_m_uniqd_prof_b_800k_5m,
        `predict_m_amt_prof_b_800k_5m` as predict_m_amt_prof_b_800k_5m,
        `predict_m_uniqd_prof_a_5m` as predict_m_uniqd_prof_a_5m,
        `predict_m_amt_prof_a_5m` as predict_m_amt_prof_a_5m
    '''

    service_name = 'Директ'
    synchronizer_class = ProfDirectPredictsSynchronizer


class ProfBusinessPredictsLoader(BasePredictsLoader):
    COLUMNS = '''
        `dt` AS dt,
        `predict_m_amt_prof_yab_a_90k` AS predict_business_grade_a,
        `predict_m_amt_prof_yab_b_40k_90k` as predict_business_grade_b,
        `predict_m_amt_prof_yab_c_3500_40k` as predict_business_grade_c,
        `predict_m_amt_prof_yab_d_3500` as predict_business_grade_d
    '''
    service_name = 'Справочник'
    synchronizer_class = ProfBusinessPredictsSynchronizer
