import logging
from crm.agency_cabinet.common.consts import CalculatorServiceType
from crm.agency_cabinet.rewards.server.src.celery.tasks.calculator.synchronizer import BaseCalculatorSynchronizer


LOGGER = logging.getLogger('celery.tasks.calculator.predicts.synchronizer')


class BasePredictsSynchronizer(BaseCalculatorSynchronizer):
    predict = True


class BaseBusinessPredictsSynchronizer(BasePredictsSynchronizer):
    service = CalculatorServiceType.business.value

    GRADE_TO_YT_COLUMN_MAP = {
        'A': {
            'revenue': 'predict_business_grade_a',
        },
        'B': {
            'revenue': 'predict_business_grade_b',
        },
        'C': {
            'revenue': 'predict_business_grade_c'
        },
        'D': {
            'revenue': 'predict_business_grade_d'
        }
    }
