from itertools import groupby
from crm.agency_cabinet.common.consts.reward import RewardsTypes
from crm.agency_cabinet.rewards.server.src.celery.tasks.deprecated.rewards_2021.load_rewards.base import BaseRewardLoader


class MonthRewardLoader(BaseRewardLoader):
    REWARD_PERIOD = RewardsTypes.month
    IS_PROF = False

    @staticmethod
    def _reducer(key, rows):
        # Перенес группировку для базовых  премий тк хуже от нее не будет
        # и как минимум одна таблица за 2021 (март) год сейчас лежит без группировки
        contract_eid = key['contract_eid']
        discount_type = key['discount_type']

        reward = 0
        amt = 0  # TODO: use decimal?
        yyymm = None

        for row in rows:
            amt += row.get('amt') or 0
            reward += row.get('reward') or 0
            if yyymm:
                yyymm = row.get('yyymm')

        yield {
            'contract_eid': contract_eid,
            'discount_type': discount_type,
            'reward': reward,
            'amt': amt,
            'yyyymm': yyymm
        }

    def _read_table(self, **kwargs):
        self._table = (next(self._reducer(key, list(group))) for key, group in groupby(
            self.client.read_table(
                self.table_path[:-1],
                **kwargs),
            lambda r: {
                'contract_eid': r['contract_eid'],
                'discount_type': r['discount_type']}))


class ProfMonthRewardLoader(MonthRewardLoader):
    IS_PROF = True


class ProfMonthLoaderYTReduce(ProfMonthRewardLoader):
    # not used now
    def _read_table(self, **kwargs):
        with self.client.TempTable() as inp:
            self.client.run_sort(self.table_path[:-1], inp, sort_by=['contract_eid', 'discount_type'])
            with self.client.TempTable() as out:
                self.client.run_reduce(self._reducer, inp, out, reduce_by=['contract_eid', 'discount_type'], **kwargs)
                self._table = self.client.read_table(out, **kwargs)
