from itertools import groupby

from crm.agency_cabinet.common.consts.reward import RewardsTypes
from crm.agency_cabinet.rewards.server.src.celery.tasks.deprecated.rewards_2021.load_rewards.base import BaseRewardLoader


class QuarterRewardLoader(BaseRewardLoader):
    REWARD_PERIOD = RewardsTypes.quarter
    IS_PROF = False


class ProfQuarterRewardLoader(QuarterRewardLoader):
    IS_PROF = True


class BusinessQuarterRewardLoader(QuarterRewardLoader):

    @staticmethod
    def _reducer(key, rows):
        contract_eid = key['contract_eid']
        discount_type = key['discount_type']

        reward = 0
        amt = 0  # TODO: use decimal?
        yyymm = None

        for row in rows:
            amt += row.get('amt') or 0
            reward += row.get('reward') or 0
            if yyymm:
                yyymm = row.get('yyymm')

        yield {
            'contract_eid': contract_eid,
            'discount_type': discount_type,
            'reward': reward,
            'amt': amt,
            'yyyymm': yyymm
        }

    def _read_table(self, **kwargs):
        table_data = sorted(
            self.client.read_table(self.table_path[:-1], **kwargs),
            key=lambda r: (r['contract_eid'], r['discount_type'])
        )

        self._table = (
            next(self._reducer(key, list(group)))
            for key, group in groupby(
                table_data,
                lambda r: {'contract_eid': r['contract_eid'], 'discount_type': r['discount_type']}
            )
        )


class BusinessProfQuarterRewardLoader(BusinessQuarterRewardLoader):
    IS_PROF = True
