from yt.wrapper import YtClient

from crm.agency_cabinet.rewards.server.config.clients import YT_CONFIG
from crm.agency_cabinet.rewards.server.src.celery.base import celery_app as celery
from . import load_single_month_table_task


@celery.task(bind=True)
def load_month_rewards_tables_from_yt_task(self):
    client = YtClient(proxy='hahn', token=YT_CONFIG['TOKEN'])

    for table in client.search(
        '//home/balance/prod/yb-ar/rewards/2020-prof-m-20_prof',
        node_type=['table'],
    ):
        load_single_month_table_task.delay(table_path=table, is_prof=True)

    for table in client.search(
        '//home/balance/prod/yb-ar/rewards/direct/2020-prof_20-m-prof',
        node_type=['table'],
    ):
        load_single_month_table_task.delay(table_path=table, is_prof=True)
