from itertools import groupby

from crm.agency_cabinet.common.consts.reward import RewardsTypes
from crm.agency_cabinet.rewards.server.src.celery.tasks.deprecated.rewards_2021.load_rewards.base import BaseRewardLoader


class SemiyearRewardLoader(BaseRewardLoader):
    REWARD_PERIOD = RewardsTypes.semiyear
    IS_PROF = False

    @staticmethod
    def _reducer(key, rows):
        contract_eid = key['contract_eid']
        discount_type = key.get('discount_type') or key.get('service_id')
        reward = 0
        amt = 0  # use decimal?
        for row in rows:
            reward += row.get('reward') or 0
            amt += row.get('amt') or 0

        yield {
            'contract_eid': contract_eid,
            'discount_type': discount_type,
            'reward': reward,
            'amt': amt,
        }

    def _read_table(self, **kwargs):
        self._table = (next(self._reducer(key, list(group))) for key, group in groupby(
            self.client.read_table(
                self.table_path[:-1],
                **kwargs),
            lambda r: {
                'contract_eid': r['contract_eid'],
                'discount_type': r['discount_type']}))


class SemiyearRewardLoaderYTReduce(SemiyearRewardLoader):
    def _read_table(self, **kwargs):
        with self.client.TempTable() as inp:
            self.client.run_sort(self.table_path[:-1], inp, sort_by=['contract_eid', 'discount_type'])
            with self.client.TempTable() as out:
                self.client.run_reduce(self._reducer, inp, out, reduce_by=['contract_eid', 'discount_type'], **kwargs)
                self._table = self.client.read_table(out, **kwargs)


class ProfSemiyearRewardLoader(SemiyearRewardLoader):
    IS_PROF = True


class ProfSemiyearRewardLoaderYTReduce(SemiyearRewardLoaderYTReduce):
    IS_PROF = True
