from crm.agency_cabinet.rewards.server.src.celery.base import celery_app as celery
from crm.agency_cabinet.rewards.server.config import DATABASE_SETTINGS
from crm.agency_cabinet.rewards.server.config.clients import YT_CONFIG
from crm.agency_cabinet.rewards.server.src.db.models import Contract
from crm.agency_cabinet.common.yt.base import YtModelLoader
from crm.agency_cabinet.rewards.server.src.db.engine import db


@celery.task
def sync_example_table():
    db_bind = db.with_bind(bind=DATABASE_SETTINGS['dsn'],
                           pool_class=DATABASE_SETTINGS['pool_class'])

    m = YtModelLoader('//home/balance/prod/yb-ar/rewards/yandex/2021-base-m-2021_m_base/202103/',
                      Contract, {'eid': 'contract_eid',
                                 'agency_id': 'invoice_id'}, {'payment_type': 'test',
                                                              'type': 'test'},
                      {'cluster': 'hahn', 'token': YT_CONFIG['TOKEN'], 'config': {}},
                      db_bind, limit=10)
    m.load()
