import datetime
from sqlalchemy import and_

from crm.agency_cabinet.rewards.server.src.celery.base import celery_app as celery
from crm.agency_cabinet.rewards.server.src.db.models import ReportMetaInfo
from crm.agency_cabinet.common.consts.report import ReportsStatuses
from crm.agency_cabinet.common.celery.base import async_to_sync
from .generate_report import LOCK_PATH, LOCK_KEY


@celery.task(bind=True)
def clear_faulty_in_progress_reports_task(self, delta_hours=1):
    now = datetime.datetime.now()

    @async_to_sync
    async def _check_in_progress_statuses():
        # set requested again? delete?

        reports = await ReportMetaInfo.query.where(and_(
            ReportMetaInfo.status == ReportsStatuses.in_progress.value,
            ReportMetaInfo.updated_at < now - datetime.timedelta(hours=delta_hours)
        )).gino.all()

        for report in reports:
            path = f'{LOCK_PATH}/{LOCK_KEY}-{report.id}'

            lock = self.LOCK_MANAGER.lock(path)
            if not lock.check_acquired():
                await report.update(status=ReportsStatuses.error.value).apply()

        # await ReportMetaInfo.update.values(status=ReportsStatuses.error.value).where(and_(
        #     ReportMetaInfo.status == ReportsStatuses.ready.value,
        #     ReportMetaInfo.file_id.is_(None)
        # )).gino.status()  # mark ready reports without files as error?

    _check_in_progress_statuses()


@celery.task(bind=True)
def clear_old_error_reports_task(self, delta_hours=24 * 3):
    now = datetime.datetime.now()

    @async_to_sync
    async def _check_error_statuses():
        # set requested again? delete?

        await ReportMetaInfo.delete.where(and_(
            ReportMetaInfo.status == ReportsStatuses.error.value,
            ReportMetaInfo.updated_at < now - datetime.timedelta(hours=delta_hours)
        )).gino.status()

    _check_error_statuses()
