import logging

from crm.agency_cabinet.common.consts.reward import RewardsTypes
from crm.agency_cabinet.rewards.server.src.celery.base import celery_app as celery

from .base import common_predicted_rewards_info_load

LOGGER = logging.getLogger('celery.load_predicted_rewards')


@celery.task(bind=True)
def load_predicted_month_rewards_info_task(self):
    common_predicted_rewards_info_load(reward_type=RewardsTypes.month)


@celery.task(bind=True)
def load_predicted_quarter_rewards_info_task(self):
    common_predicted_rewards_info_load(reward_type=RewardsTypes.quarter)


@celery.task(bind=True)
def load_predicted_semiyear_rewards_info_task(self):
    common_predicted_rewards_info_load(reward_type=RewardsTypes.semiyear)
