import logging

from crm.agency_cabinet.common.consts.reward import RewardsTypes
from crm.agency_cabinet.rewards.server.src.celery.base import celery_app as celery

from .base import common_rewards_info_load

LOGGER = logging.getLogger('celery.load_rewards')


@celery.task(bind=True)
def load_month_rewards_info_task(self, period_from: str = None, force_load: bool = False):
    common_rewards_info_load(reward_type=RewardsTypes.month, period_from=period_from, force_load=force_load)


@celery.task(bind=True)
def load_quarter_rewards_info_task(self, period_from: str = None, force_load: bool = False):
    common_rewards_info_load(reward_type=RewardsTypes.quarter, period_from=period_from, force_load=force_load)


@celery.task(bind=True)
def load_semiyear_rewards_info_task(self, period_from: str = None, force_load: bool = False):
    common_rewards_info_load(reward_type=RewardsTypes.semiyear, period_from=period_from, force_load=force_load)
