from crm.agency_cabinet.common.consts.contract import ContractType
from crm.agency_cabinet.common.db.models import BaseModel, db


class Contract(BaseModel):
    __tablename__ = 'contract'

    id = db.Column(db.BigInteger, primary_key=True)
    eid = db.Column(db.Text, nullable=False, unique=True)
    agency_id = db.Column(db.BigInteger, nullable=False)
    payment_type = db.Column(db.Text, nullable=False)
    type = db.Column(db.Text, nullable=False)
    inn = db.Column(db.Text)
    finish_date = db.Column(db.DateTime(timezone=True))
    services = db.Column(db.ARRAY(db.String))
    person_id = db.Column(db.BigInteger)
    is_crisis = db.Column(db.Boolean, nullable=False, server_default='f', default=False)

    __table_args__ = (
        db.Index(
            'contract__eid_idx',
            'eid',
            unique=True
        ),
        db.Index(
            'contract__agency_id_idx',
            'agency_id',
            unique=False
        ),
    )

    @property
    def is_prof(self):
        return self.type == ContractType.prof.value
