from crm.agency_cabinet.common.db.models import BaseModel, db

from crm.agency_cabinet.rewards.server.src.db.models.reward import Reward


class Document(BaseModel):
    __tablename__ = 'document'

    id = db.Column(db.BigInteger, primary_key=True)
    reward_id = db.Column(db.BigInteger, nullable=False)
    yadoc_id = db.Column(db.BigInteger, nullable=True)

    name = db.Column(db.String, nullable=False)
    type = db.Column(db.Text, nullable=False)
    sending_date = db.Column(db.DateTime(timezone=True))
    got_scan = db.Column(db.Boolean, nullable=False, server_default='f')
    got_original = db.Column(db.Boolean, nullable=False, server_default='f')

    __table_args__ = (
        db.ForeignKeyConstraint(['reward_id'], ['reward.id'], ondelete='CASCADE'),
    )

    _reward = None

    @property
    def reward(self) -> Reward:
        return self._reward

    @reward.setter
    def reward(self, value: Reward):
        self._reward = value
