from sqlalchemy.dialects.postgresql import ARRAY  # noqa

from crm.agency_cabinet.common.db.models import BaseModel, db
from crm.agency_cabinet.rewards.server.src.db.models.contract import Contract
from crm.agency_cabinet.rewards.server.src.db.models.mds import S3MdsFile
from crm.agency_cabinet.common.consts.report import ReportsStatuses


class ReportMetaInfo(BaseModel):
    __tablename__ = 'report_meta_info'

    id = db.Column(db.BigInteger, primary_key=True)
    name = db.Column(db.Text, nullable=False)

    contract_id = db.Column(db.BigInteger, nullable=False)
    file_id = db.Column(db.BigInteger, nullable=True)  # TODO: add unique constraint??

    type = db.Column(db.Text, nullable=False)  # TODO: make constraint based on possible constants
    service = db.Column(db.Text, nullable=False)  # TODO make constraint based on possible constants

    period_from = db.Column(db.DateTime(timezone=True), nullable=False)
    period_to = db.Column(db.DateTime(timezone=True), nullable=False)

    clients_ids = db.Column(ARRAY(db.BigInteger))

    status = db.Column(db.Text, nullable=False, default=ReportsStatuses.requested.value)  # TODO: make constraint based on possible constants

    __table_args__ = (
        db.ForeignKeyConstraint(['contract_id'], ['contract.id'], ondelete='CASCADE'),
        db.ForeignKeyConstraint(['file_id'], ['s3_mds_file.id'], ondelete='CASCADE'),
    )

    _contract = None
    _file = None

    @property
    def contract(self) -> Contract:
        return self._contract

    @contract.setter
    def contract(self, value: Contract):
        self._contract = value

    @property
    def file(self) -> S3MdsFile:
        return self._file

    @file.setter
    def file(self, value: S3MdsFile):
        self._file = value
