from crm.agency_cabinet.common.db.models import BaseModel, db
from crm.agency_cabinet.rewards.server.src.db.models.contract import Contract


class Reward(BaseModel):
    __tablename__ = 'reward'

    id = db.Column(db.BigInteger, primary_key=True)
    contract_id = db.Column(db.BigInteger, nullable=False)
    type = db.Column(db.Text, nullable=False)
    payment = db.Column(db.Numeric(precision=18, scale=6), nullable=True, default=0)
    payment_date = db.Column(db.DateTime(timezone=True), nullable=True)
    period_from = db.Column(db.DateTime(timezone=True), nullable=False)
    got_scan = db.Column(db.Boolean, nullable=False, server_default='f')
    got_original = db.Column(db.Boolean, nullable=False, server_default='f')
    is_accrued = db.Column(db.Boolean, nullable=False, server_default='f')  # remove ???
    is_paid = db.Column(db.Boolean, nullable=False, server_default='f')
    is_prof = db.Column(db.Boolean, nullable=False, default=False)  # check with contract type???
    predict = db.Column(db.Boolean, nullable=False, default=False, server_default='f')

    __table_args__ = (
        db.ForeignKeyConstraint(['contract_id'], ['contract.id']),
        db.UniqueConstraint('contract_id', 'period_from', 'type', name='reward__contract_id_period_from_type__uc')
    )

    _contract = None

    @property
    def contract(self) -> Contract:
        return self._contract

    @contract.setter
    def contract(self, value: Contract):
        self._contract = value
