import typing
from collections import defaultdict
from crm.agency_cabinet.rewards.server.src.db import models, db


async def build_contract_to_services_map(contract_ids: typing.Iterable[int]) -> typing.Mapping[int, typing.Set[str]]:
    services_map = defaultdict(set)
    for contract_id, services in await db.select(
        [
            models.Reward.contract_id,
            db.func.array_agg(db.func.distinct(models.ServiceReward.service))
        ]
    ).select_from(
        models.Reward.join(models.ServiceReward)
    ).where(
        models.Reward.contract_id.in_(contract_ids)
    ).group_by(
        models.Reward.contract_id
    ).gino.all():
        services_map[contract_id] = set(services)
    return services_map
