from crm.agency_cabinet.common.cache import cached, TTLCache
from crm.agency_cabinet.common.consts.report import ReportsStatuses
from crm.agency_cabinet.common.monitoring.utils.server import BaseMetricsHandler
from crm.agency_cabinet.rewards.server.src.db import db, models


class RewardsMetricsHandler(BaseMetricsHandler):

    def __init__(self, current_db, *args, **kwargs):
        super().__init__(*args, **kwargs)
        self.db = current_db

    @cached(cache=TTLCache(ttl=60, maxsize=10))
    async def get_error_reports_count(self):
        return await self.db.select(
            [
                db.func.count(models.ReportMetaInfo.id)
            ]
        ).where(
            models.ReportMetaInfo.status == ReportsStatuses.error.value
        ).gino.scalar()

    async def build_metrics(self, registry, request):
        await super().build_metrics(registry, request)
        registry.int_gauge({'sensor': 'rewards.error_reports'}).set(await self.get_error_reports_count())
