from dataclasses import dataclass
from sqlalchemy import and_
from crm.agency_cabinet.common.consts import ContractType, get_start_of_current_fin_year_with_dt
from crm.agency_cabinet.rewards.common import structs
from crm.agency_cabinet.rewards.server.src.db import models
from crm.agency_cabinet.rewards.server.src.db.queries import build_contract_to_services_map


@dataclass
class GetContractsInfo:
    async def __call__(self, request: structs.GetContractsInfoRequest) -> structs.GetContractsInfoResponse:
        contracts = await models.Contract.query.where(
            and_(
                models.Contract.agency_id == request.agency_id,
                models.Contract.finish_date > get_start_of_current_fin_year_with_dt()
            )
        ).gino.all()
        services_map = await build_contract_to_services_map((contract.id for contract in contracts))
        return structs.GetContractsInfoResponse(
            contracts=[structs.ContractInfo(
                contract_id=contract.id,
                eid=contract.eid,
                inn=contract.inn,
                is_crisis=contract.is_crisis,
                payment_type=contract.payment_type,
                services=sorted(set(contract.services or []) | services_map[contract.id]),
                finish_date=contract.finish_date,
                type=ContractType(contract.type) if contract.type in [i.value for i in ContractType] else ContractType.unknown
            ) for contract in contracts]
        )
