from dataclasses import dataclass
from aiohttp import ClientResponseError
from aiohttp.web import HTTPNotFound

from crm.agency_cabinet.rewards.common import structs
from crm.agency_cabinet.rewards.server.src.db import Document
from crm.agency_cabinet.common.yadoc import YaDocClient

from .exceptions import NoSuchDocument, FileNotFound


@dataclass
class GetDocumentUrl:
    async def __call__(
        self,
        request:
        structs.GetDocumentUrlRequest,
        yadoc_client: YaDocClient
    ) -> structs.GetDocumentUrlResponse:

        document: Document = await Document.query.where(Document.id == request.document_id).gino.first()

        if document is None:
            raise NoSuchDocument

        if document.yadoc_id is None:
            raise FileNotFound

        # if document.contract.agency_id != request.agency_id:
        #    raise UnsuitableAgency  # TODO: check

        try:
            url = await yadoc_client.get_doc_url(document.yadoc_id)
        except ClientResponseError as ex:
            if ex.status == HTTPNotFound.status_code:
                raise FileNotFound from ex
            raise ex

        return structs.GetDocumentUrlResponse(
            document_url=url
        )
