PY3_LIBRARY()

OWNER(
    g:agency_cabinet_back
)


PEERDIR(
    crm/agency_cabinet/rewards/common
    crm/agency_cabinet/common/cache
    crm/agency_cabinet/common/bunker
    crm/agency_cabinet/common/config
    crm/agency_cabinet/common/consts
    crm/agency_cabinet/common/celery
    crm/agency_cabinet/common/yadoc
    crm/agency_cabinet/common/db
    crm/agency_cabinet/common/service_discovery
    crm/agency_cabinet/common/server/rpc
    crm/agency_cabinet/common/yql
    crm/agency_cabinet/common/yt
    crm/agency_cabinet/common/chyt
    crm/agency_cabinet/rewards/proto
    crm/agency_cabinet/common/monitoring

    yql/library/python
    library/python/monlib
)


PY_SRCS(
    src/__init__.py
    src/monitoring.py
    src/handler.py
    src/db/engine.py
    src/db/__init__.py
    src/db/models/__init__.py
    src/db/models/mds.py
    src/db/models/calculator.py
    src/db/models/condition.py
    src/db/models/contract.py
    src/db/models/document.py
    src/db/models/reward.py
    src/db/models/report.py
    src/db/models/service_reward.py
    src/db/queries.py
    src/celery/__init__.py
    src/celery/base.py
    src/celery/tasks/__init__.py
    src/celery/tasks/reports/__init__.py
    src/celery/tasks/reports/generate_report.py
    src/celery/tasks/reports/check_report_statuses.py
    src/celery/tasks/example.py
    src/celery/tasks/calculator/__init__.py
    src/celery/tasks/calculator/base.py
    src/celery/tasks/calculator/loader.py
    src/celery/tasks/calculator/synchronizer.py
    src/celery/tasks/calculator/actual/__init__.py
    src/celery/tasks/calculator/actual/loader.py
    src/celery/tasks/calculator/actual/synchronizer.py
    src/celery/tasks/calculator/actual/aggregator/__init__.py
    src/celery/tasks/calculator/actual/aggregator/loader.py
    src/celery/tasks/calculator/actual/aggregator/synchronizer.py
    src/celery/tasks/calculator/actual/base/__init__.py
    src/celery/tasks/calculator/actual/base/loader.py
    src/celery/tasks/calculator/actual/base/synchronizer.py
    src/celery/tasks/calculator/actual/prof/__init__.py
    src/celery/tasks/calculator/actual/prof/loader.py
    src/celery/tasks/calculator/actual/prof/synchronizer.py
    src/celery/tasks/calculator/predicts/__init__.py
    src/celery/tasks/calculator/predicts/loader.py
    src/celery/tasks/calculator/predicts/synchronizer.py
    src/celery/tasks/calculator/predicts/aggregator/__init__.py
    src/celery/tasks/calculator/predicts/aggregator/loader.py
    src/celery/tasks/calculator/predicts/aggregator/synchronizer.py
    src/celery/tasks/calculator/predicts/prof/__init__.py
    src/celery/tasks/calculator/predicts/prof/loader.py
    src/celery/tasks/calculator/predicts/prof/synchronizer.py
    src/celery/tasks/calculator/predicts/base/__init__.py
    src/celery/tasks/calculator/predicts/base/loader.py
    src/celery/tasks/calculator/predicts/base/synchronizer.py
    src/celery/tasks/deprecated/calculator_2021/base/__init__.py
    src/celery/tasks/deprecated/calculator_2021/base/base.py
    src/celery/tasks/deprecated/calculator_2021/base/early_payment_loader.py
    src/celery/tasks/deprecated/calculator_2021/base/predict_data_loader.py
    src/celery/tasks/deprecated/calculator_2021/base/revenue_loader.py
    src/celery/tasks/deprecated/calculator_2021/direct.py
    src/celery/tasks/deprecated/calculator_2021/media.py
    src/celery/tasks/deprecated/calculator_2021/video.py
    src/celery/tasks/contracts/load_contracts_info.py
    src/celery/tasks/documents/__init__.py
    src/celery/tasks/documents/load_documents.py
    src/celery/tasks/documents/load_yadoc_ids.py
    src/celery/tasks/deprecated/rewards_2021/load_rewards/__init__.py
    src/celery/tasks/deprecated/rewards_2021/load_rewards/base.py
    src/celery/tasks/deprecated/rewards_2021/load_rewards/early_payment.py
    src/celery/tasks/deprecated/rewards_2021/load_rewards/month.py
    src/celery/tasks/deprecated/rewards_2021/load_rewards/quarter.py
    src/celery/tasks/deprecated/rewards_2021/load_rewards/rewards_2020.py
    src/celery/tasks/deprecated/rewards_2021/load_rewards/reward_payment.py
    src/celery/tasks/deprecated/rewards_2021/load_rewards/semiyear.py
    src/celery/tasks/rewards/__init__.py
    src/celery/tasks/rewards/common.py
    src/celery/tasks/rewards/load_rewards/__init__.py
    src/celery/tasks/rewards/load_rewards/base.py
    src/celery/tasks/rewards/load_predicted_rewards/__init__.py
    src/celery/tasks/rewards/load_predicted_rewards/base.py
    src/procedures/__init__.py
    src/procedures/calculator.py
    src/procedures/dashboard.py
    src/procedures/contracts_info.py
    src/procedures/rewards_info.py
    src/procedures/reports.py
    src/procedures/documents.py
    src/procedures/exceptions.py
    src/common/utils.py
    config/__init__.py
    config/bunker.py
    config/lock.py
    config/celery_settings.py
    config/clients.py
    config/mds.py
    config/sqs.py
    config/db.py
    config/data_loaders.py
    config/tvm.py
)


END()

RECURSE(
    bin
    migrations
)

RECURSE_FOR_TESTS(tests)
