package ru.yandex.crm.apphost.kotlin.common.apphost

import org.koin.dsl.bind
import org.koin.dsl.module
import ru.yandex.crm.apphost.kotlin.common.tvm.withTvmSupport
import ru.yandex.crm.library.kotlin.service.HostBuilder
import ru.yandex.crm.library.kotlin.service.Service
import ru.yandex.crm.library.kotlin.service.addOptions
import ru.yandex.web.apphost.api.grpc.AppHostTypedServant

private val appHostModule = module {
    addOptions<AppHostConfig>("apphost")
    single {
        AppHostService(
            get(),
            getAll<AppHostPathHandler>().distinctBy { it.javaClass },
            getAll<AppHostTypedServant>().distinctBy { it.javaClass },
            get(),
        )
    } bind Service::class
}

fun HostBuilder.withAppHost(): HostBuilder = this.withModule(appHostModule).withTvmSupport()
