package ru.yandex.crm.apphost.kotlin.common.apphost

import mu.KotlinLogging
import org.apache.logging.log4j.ThreadContext
import ru.yandex.web.apphost.api.request.RequestContext
import java.util.function.Consumer

const val REQUEST_ID = "REQUEST_ID"
const val REQUEST_GUID = "REQUEST_GUID"

@Deprecated("Use typed definitions (AppHostTypedServant)")
interface AppHostPathHandler : Consumer<RequestContext> {
    companion object {
        private val logger = KotlinLogging.logger { }
    }

    val path: String

    fun handle(ctx: RequestContext)

    override fun accept(ctx: RequestContext) {
        setupLoggingContext(ctx)
        logger.info("Handling apphost request {}", path)
        try {
            handle(ctx)
        } catch (e: Exception) {
            logger.error("Failed to process apphost request", e)
            throw e
        } finally {
            ThreadContext.clearAll()
        }
    }

    private fun setupLoggingContext(context: RequestContext) {
        ThreadContext.put(REQUEST_ID, context.requestId ?: "EMPTY_REQUEST_ID")
        ThreadContext.put(REQUEST_GUID, context.guid ?: "EMPTY_REQUEST_GUID")
    }
}
