package ru.yandex.crm.apphost.kotlin.common.apphost

import io.grpc.Metadata
import io.grpc.ServerCall
import io.grpc.ServerCallHandler
import io.grpc.ServerInterceptor
import ru.yandex.web.apphost.grpc.proto.TServiceRequest
import ru.yandex.web.apphost.grpc.proto.TServiceResponse

abstract class AppHostServerInterceptor : ServerInterceptor {
    @Suppress("UNCHECKED_CAST")
    final override fun <RequestType : Any?, ResponseType : Any?> interceptCall(
        call: ServerCall<RequestType, ResponseType>?,
        headers: Metadata?,
        next: ServerCallHandler<RequestType, ResponseType>?
    ): ServerCall.Listener<RequestType> {
        val appHostCall = call as ServerCall<TServiceRequest, TServiceResponse>?
        val appHostNextHandler = next as ServerCallHandler<TServiceRequest, TServiceResponse>?
        return interceptTypedCall(appHostCall, headers, appHostNextHandler) as ServerCall.Listener<RequestType>
    }

    abstract fun interceptTypedCall(
        call: ServerCall<TServiceRequest, TServiceResponse>?,
        headers: Metadata?,
        next: ServerCallHandler<TServiceRequest, TServiceResponse>?
    ): ServerCall.Listener<TServiceRequest>
}
