package ru.yandex.crm.apphost.kotlin.common.apphost

import com.google.protobuf.ByteString
import io.grpc.ForwardingServerCallListener.SimpleForwardingServerCallListener
import io.grpc.Metadata
import io.grpc.ServerCall
import io.grpc.ServerCallHandler
import io.grpc.Status
import mu.KotlinLogging
import ru.yandex.passport.tvmauth.TicketStatus
import ru.yandex.passport.tvmauth.TvmClient
import ru.yandex.web.apphost.grpc.proto.TServiceRequest
import ru.yandex.web.apphost.grpc.proto.TServiceResponse

class AuthenticationInterceptor(private val tvmClient: TvmClient) : AppHostServerInterceptor() {
    companion object {
        val logger = KotlinLogging.logger { }
    }

    override fun interceptTypedCall(
        call: ServerCall<TServiceRequest, TServiceResponse>?,
        headers: Metadata?,
        next: ServerCallHandler<TServiceRequest, TServiceResponse>?
    ): ServerCall.Listener<TServiceRequest> {
        if (next === null) {
            throw java.lang.Exception("there is no next call handler")
        }

        return Listener(next.startCall(call, headers), call, tvmClient)
    }

    private class Listener(
        delegate: ServerCall.Listener<TServiceRequest>,
        private val call: ServerCall<TServiceRequest, TServiceResponse>?,
        private val tvmClient: TvmClient
    ) : SimpleForwardingServerCallListener<TServiceRequest>(delegate) {
        override fun onMessage(request: TServiceRequest) {
            with(tvmClient.checkServiceTicket(request.ticket)) {
                if (status !== TicketStatus.OK) {
                    logger.info("Service ticket is invalid: {}", status)
                    logger.debug("Debug info: {}", debugInfo())

                    val response = TServiceResponse.newBuilder()
                        .setException(ByteString.copyFromUtf8("Not authenticated"))
                        .build()
                    call?.sendHeaders(Metadata())
                    call?.sendMessage(response)
                    call?.close(Status.UNAUTHENTICATED, Metadata())
                    return
                }
            }

            super.onMessage(request)
        }
    }
}
