package ru.yandex.crm.apphost.kotlin.common.extensions

import ru.yandex.web.apphost.api.exception.AppHostItemExpectationException
import ru.yandex.web.apphost.api.request.ApphostRequest
import ru.yandex.web.apphost.api.request.RequestItem

fun ApphostRequest.getSingleRequestItemOrNull(itemType: String?): RequestItem? {
    val items = getRequestItems(itemType)
    if (items.isEmpty()) {
        return null
    }
    if (items.size == 1) {
        return items.first()
    }
    throw AppHostItemExpectationException("More than one request item with item type: $itemType")
}
