package ru.yandex.crm.apphost.kotlin.common.extensions

import NAppHostHttp.Http
import NAppHostHttp.Http.THttpRequest

fun THttpRequest.getHeader(name: String) =
    headersList.firstOrNull { it.name.lowercase() == name.lowercase() }

fun THttpRequest.getHeaderValue(name: String) =
    getHeader(name)?.value

fun THttpRequest.Builder.addHeader(name: String, value: String): THttpRequest.Builder {
    val header = Http.THeader.newBuilder().apply {
        setName(name)
        setValue(value)
    }.build()
    return addHeaders(header)
}
