package ru.yandex.crm.apphost.kotlin.common.extensions

import NAppHostHttp.Http

fun Http.THttpResponse.Builder.addHeader(name: String, value: String): Http.THttpResponse.Builder {
    val header = Http.THeader.newBuilder().apply {
        setName(name)
        setValue(value)
    }.build()
    return addHeaders(header)
}

fun Http.THttpResponse.Builder.setContentType(type: String) = addHeader("Content-Type", type)
