package ru.yandex.crm.apphost.kotlin.common.extensions

import com.google.protobuf.Timestamp
import ru.yandex.crm.proto.gallifrey.crm.Base.Date
import ru.yandex.crm.proto.gallifrey.crm.Base.Time
import java.time.Instant
import java.time.LocalDate
import java.time.LocalTime

fun Instant.toProtobufTimestamp() =
    Timestamp.newBuilder()
        .setSeconds(epochSecond)
        .setNanos(nano)
        .build()

fun Timestamp.toInstant() =
    Instant.ofEpochSecond(seconds, nanos.toLong())

fun Date.toLocalDate() =
    LocalDate.parse(value)

fun Time.toLocalTime() =
    LocalTime.parse(value)

fun LocalDate.toProtobufDate() =
    Date.newBuilder()
        .setValue(toString())
        .build()

fun LocalTime.toProtobufTimestamp() =
    Time.newBuilder()
        .setValue(toString())
        .build()
