package ru.yandex.crm.apphost.kotlin.common.middleware

import kotlinx.coroutines.runBlocking
import ru.yandex.web.apphost.api.AppHostPathHandler
import ru.yandex.web.apphost.api.request.RequestContext

class ApphostPathHandlerPipeline(
    private val path: String,
    middlewares: List<Middleware>,
) : AppHostPathHandler {

    val pipelinedHandler: suspend (RequestContext) -> Unit

    init {
        var asyncHandler: (suspend (RequestContext) -> Unit)? = null
        middlewares.asReversed().forEach { middleware ->
            val next = asyncHandler
            asyncHandler = { middleware.process(it, next) }
        }
        pipelinedHandler = asyncHandler ?: { throw IllegalArgumentException("There is no middlewares for $path") }
    }

    override fun getPath(): String = path

    override fun accept(ctx: RequestContext) = runBlocking {
        pipelinedHandler(ctx)
    }
}
