package ru.yandex.crm.apphost.kotlin.common.middleware

import ru.yandex.crm.apphost.kotlin.common.middleware.logging.useLogging
import ru.yandex.web.apphost.api.AppHostPathHandler
import ru.yandex.web.apphost.api.request.RequestContext
import java.util.function.Consumer

class ApphostPathHandlerPipelineBuilder private constructor(
    private val path: String,
    private val action: Consumer<RequestContext>
) {
    companion object {
        fun createDefaultFor(pathHandler: AppHostPathHandler) =
            ApphostPathHandlerPipelineBuilder(pathHandler.path, pathHandler::accept)
                .useLogging()
    }

    private val middlewares: MutableList<Middleware> = mutableListOf()

    fun useMiddleware(middleware: Middleware) = this.apply {
        middlewares.add(middleware)
    }

    fun build(): AppHostPathHandler {
        val action = action
        middlewares.add(object : Middleware {
            override suspend fun process(ctx: RequestContext, next: (suspend (ctx: RequestContext) -> Unit)?) {
                action.accept(ctx)
            }
        })
        return ApphostPathHandlerPipeline(path, middlewares)
    }
}
