package ru.yandex.crm.apphost.kotlin.common.middleware.logging

import kotlinx.coroutines.slf4j.MDCContext
import kotlinx.coroutines.withContext
import mu.KotlinLogging
import mu.withLoggingContext
import ru.yandex.crm.apphost.kotlin.common.apphost.REQUEST_GUID
import ru.yandex.crm.apphost.kotlin.common.apphost.REQUEST_ID
import ru.yandex.crm.apphost.kotlin.common.middleware.Middleware
import ru.yandex.web.apphost.api.request.RequestContext

class LoggingMiddleware : Middleware {
    companion object {
        private val logger = KotlinLogging.logger { }
    }

    override suspend fun process(ctx: RequestContext, next: (suspend (ctx: RequestContext) -> Unit)?) {
        withLoggingContext(
            REQUEST_ID to (ctx.requestId ?: "EMPTY_REQUEST_ID"),
            REQUEST_GUID to (ctx.guid ?: "EMPTY_REQUEST_GUID")
        ) {
            logger.info("Handling apphost request {}", ctx.location.path)
            try {
                withContext(MDCContext()) { next?.invoke(ctx) }
            } catch (e: Exception) {
                logger.error("Failed to process apphost request", e)
                throw e
            }
        }
    }
}
