package ru.yandex.crm.apphost.kotlin.common.tvm

import org.koin.core.scope.Scope
import org.koin.dsl.bind
import org.koin.dsl.module
import ru.yandex.crm.library.kotlin.service.HostBuilder
import ru.yandex.crm.library.kotlin.service.addOptions
import ru.yandex.passport.tvmauth.NativeTvmClient
import ru.yandex.passport.tvmauth.TvmClient
import ru.yandex.passport.tvmauth.TvmToolSettings

fun HostBuilder.withTvmSupport(): HostBuilder = this.withModule(module {
    addOptions<TvmConfig>("tvm")
    addOptions<TvmConfig.TvmToolConfig>("tvm.tool")
    addOptions<TvmConfig.TvmToolConfig.TvmToolCustomConfig>("tvm.tool.custom")
    single {
        val config = get<TvmConfig>()
        val provider = if (config.type === TvmClientType.TvmTool) {
            TvmToolClientProvider()
        } else if (config.type === TvmClientType.TvmApi) {
            throw NotImplementedError("Tvm api is not supported yet")
        } else {
            throw UnsupportedOperationException("Invalid tvm client type: ${config.type}")
        }

        provider.invoke(this)
    } bind TvmClient::class
})

interface TvmClientProvider : (Scope) -> TvmClient

class TvmToolClientProvider : TvmClientProvider {
    override fun invoke(scope: Scope): TvmClient {
        val config = scope.get<TvmConfig.TvmToolConfig>()
        val settings = TvmToolSettings(config.selfAlias)
        if (config.installation === TvmToolInstallation.Custom) {
            with(scope.get<TvmConfig.TvmToolConfig.TvmToolCustomConfig>()) {
                settings.apply {
                    setHostname(hostname)
                    setPort(port)
                    setAuthToken(authToken)
                }
            }
        }
        return NativeTvmClient(settings)
    }
}
