package ru.yandex.crm.apphost.kotlin.common.validator

abstract class ModelValidator <T: Any> {

    data class FailedValidations(
        val checkNumber: Int,
        val testDescription: String,
    )

    protected abstract val configuration: ValidatorConfiguration<T>

    fun validate(instance: T): List<FailedValidations> {
        val validators = configuration.getAllValidators()
        val checkResults = mutableListOf<FailedValidations>()

        validators.forEachIndexed { index, validator ->
            val invokeResult = validator.checker.invoke(instance)
            if (!invokeResult) {
                val validation = FailedValidations(index, validator.description)
                checkResults.add(validation)
            }
        }

        return checkResults
    }
}
