package ru.yandex.crm.apphost.kotlin.common.validator

fun <T: Any> emptyValidator(): ValidatorConfiguration<T> {
    return ValidatorConfiguration<T>()
}

fun Collection<ModelValidator.FailedValidations>.errorIfNotEmpty(): Unit {
    if (isEmpty()) {
        return
    }

    val message = StringBuilder("Validation error: ")
    forEach { validation ->
        message.append(validation.testDescription)
        message.append(", ")
    }
    error(message.toString())
}
