package ru.yandex.crm.apphost.kotlin.common.validator

class ValidatorConfiguration <T: Any> internal constructor() {

    internal data class Validator <T> (val description: String, val checker: T.() -> Boolean)

    private val validators = mutableListOf<Validator<T>>()

    fun addValidation(description: String, checker: T.() -> Boolean): ValidatorConfiguration<T> {
        val validator = Validator(description, checker)
        validators.add(validator)
        return this
    }

    fun addValidation(index: Int, description: String, checker: T.() -> Boolean): ValidatorConfiguration<T> {
        val validator = Validator(description, checker)
        validators.add(index, validator)
        return this
    }

    fun removeValidationAt(index: Int): ValidatorConfiguration<T> {
        validators.removeAt(index)
        return this
    }

    fun with(anotherValidator: ValidatorConfiguration<T>): ValidatorConfiguration<T> {
        validators.addAll(anotherValidator.validators)
        return this
    }

    internal fun getAllValidators(): List<Validator<T>> {
        return validators
    }
}
