package ru.yandex.crm.apphost.kotlin.dal.accessmanager

import org.hibernate.annotations.GenericGenerator
import java.io.Serializable
import java.util.UUID
import javax.persistence.CascadeType
import javax.persistence.Column
import javax.persistence.Entity
import javax.persistence.FetchType
import javax.persistence.GeneratedValue
import javax.persistence.Id
import javax.persistence.OneToMany
import javax.persistence.Table

@Entity
@Table(
    name = "security_profile",
    schema = "accessmanager"
)
open class SecurityProfile(

    @Id
    @GeneratedValue(generator = "UUID")
    @GenericGenerator(name = "UUID", strategy = "org.hibernate.id.UUIDGenerator")
    @Column(name = "id", nullable = false, updatable = false)
    open var id: UUID? = null,

    @Column(name = "organization_id")
    open var organizationId: Long = 0,

    @Column(name = "owner_department_id")
    open var ownerDepartmentId: UUID = UUID(0, 0),

    @OneToMany(mappedBy = "id.securityProfile", cascade = [CascadeType.ALL], fetch = FetchType.EAGER)
    open var names: MutableSet<SecurityProfileName> = mutableSetOf(),

    @Column(name = "is_deleted", nullable = false)
    open var isDeleted: Boolean = false,
) : Serializable {

    fun populateNew(newData: SecurityProfile) = this.apply {
        organizationId = newData.organizationId
        ownerDepartmentId = newData.ownerDepartmentId
        names = newData.names.map { SecurityProfileName().populateNew(it, this@SecurityProfile) }.toMutableSet()
    }
}
