package ru.yandex.crm.apphost.kotlin.dal.accessmanager

import java.io.Serializable
import javax.persistence.Column
import javax.persistence.EmbeddedId
import javax.persistence.Entity
import javax.persistence.Table

@Entity
@Table(
    name = "security_profile_name",
    schema = "accessmanager"
)
open class SecurityProfileName(

    @EmbeddedId
    open var id: SecurityProfileNameId? = null,

    @Column(name = "organization_id")
    open var organizationId: Long = 0,

    @Column(name = "name", nullable = false, length = 255)
    open var name: String = "",
) : Serializable {

    fun populateNew(newData: SecurityProfileName, profile: SecurityProfile) = this.apply {
        id = SecurityProfileNameId().apply {
            securityProfile = profile
            languageCode = newData.id!!.languageCode
        }
        organizationId = newData.organizationId
        name = newData.name
    }
}
