package ru.yandex.crm.apphost.kotlin.dal.departmentmanager

import org.hibernate.annotations.GenericGenerator
import java.io.Serializable
import java.util.UUID
import javax.persistence.*
import javax.persistence.FetchType.EAGER

@Entity
@Table(
    name = "department",
    schema = "departmentmanager"
)
open class Department(

    @Id
    @GeneratedValue(generator = "UUID")
    @GenericGenerator(name = "UUID", strategy = "org.hibernate.id.UUIDGenerator")
    @Column(name = "id", nullable = false, updatable = false)
    open var id: UUID? = null,

    @Column(name = "organization_id")
    open var organizationId: Long = 0,

    @ManyToOne
    @JoinColumn(name = "parent_department_id", referencedColumnName = "id")
    open var parentDepartment: Department? = null,

    @OneToMany(mappedBy = "id.department", cascade = [ CascadeType.ALL ], fetch = EAGER, orphanRemoval = true)
    open var names: MutableSet<DepartmentName> = mutableSetOf(),

    @OneToMany(
        mappedBy = "department",
        cascade = [CascadeType.PERSIST, CascadeType.REFRESH, CascadeType.MERGE]
    )
    open var memberUsers: MutableList<DepartmentUser> = mutableListOf(),

    @OneToMany(
        mappedBy = "department",
        cascade = [CascadeType.PERSIST, CascadeType.REFRESH, CascadeType.MERGE]
    )
    open var responsibleUsers: MutableList<DepartmentResponsibleUser> = mutableListOf(),

    @Column(name = "is_active", nullable = false)
    open var isActive: Boolean = true,
): Serializable {

    override fun equals(other: Any?): Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as Department

        if (id != other.id) return false

        return true
    }

    override fun hashCode(): Int {
        return id?.hashCode() ?: 0
    }
}
