package ru.yandex.crm.apphost.kotlin.dal.departmentmanager

import java.io.Serializable
import javax.persistence.Column
import javax.persistence.Embeddable
import javax.persistence.JoinColumn
import javax.persistence.ManyToOne

@Embeddable
open class DepartmentNameId(

    @ManyToOne
    @JoinColumn(name = "department_id", referencedColumnName = "id")
    open var department: Department = Department(),

    @Column(name = "organization_id", nullable = false)
    open var organizationId: Long = -1,

    @Column(name = "language_code", length = 2, nullable = false)
    open var languageCode: String = "",
): Serializable {

    override fun equals(other: Any?): Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as DepartmentNameId

        if (department != other.department) return false
        if (languageCode != other.languageCode) return false

        return true
    }

    override fun hashCode(): Int {
        var result = department.hashCode()
        result = 31 * result + languageCode.hashCode()
        return result
    }
}
