package ru.yandex.crm.apphost.kotlin.dal.departmentmanager

import org.hibernate.annotations.GenericGenerator
import ru.yandex.crm.apphost.kotlin.dal.organizationmanager.Organization
import java.util.*
import javax.persistence.*

@Entity
@Table(
    name = "department_responsible_user",
    schema = "departmentmanager"
)
open class DepartmentResponsibleUser(

    @Id
    @GeneratedValue(generator = "UUID")
    @GenericGenerator(name = "UUID", strategy = "org.hibernate.id.UUIDGenerator")
    @Column(name = "id", nullable = false, updatable = false)
    open var id: UUID? = null,

    @ManyToOne(
        cascade = [CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH],
    )
    @JoinColumn(name = "department_id", referencedColumnName = "id", nullable = false)
    open var department: Department = Department(),

    @Column(name = "organization_id", nullable = false)
    open var organization: Long = -1,

    @Column(name = "user_id", nullable = false)
    open var user: Long = -1,
) {

    override fun equals(other: Any?): Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as DepartmentResponsibleUser

        if (id != other.id) return false

        return true
    }

    override fun hashCode(): Int {
        return id?.hashCode() ?: 0
    }
}
