package ru.yandex.crm.apphost.kotlin.dal.departmentmanager

import org.hibernate.annotations.GenericGenerator
import ru.yandex.crm.apphost.kotlin.dal.usermanager.User
import java.util.*
import javax.persistence.*

@Entity
@Table(
    name = "department_user",
    schema = "departmentmanager"
)
open class DepartmentUser(

    @Id
    @GeneratedValue(generator = "UUID")
    @GenericGenerator(name = "UUID", strategy = "org.hibernate.id.UUIDGenerator")
    @Column(name = "id", nullable = false, updatable = false)
    open var id: UUID? = null,

    @ManyToOne(
        cascade = [CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH],
    )
    @JoinColumn(name = "department_id", referencedColumnName = "id", nullable = false)
    open var department: Department = Department(),

    @ManyToOne(
        cascade = [CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH],
    )
    @JoinColumn(name = "user_id", referencedColumnName = "user_id", nullable = false)
    open var user: User = User(),

    @Column(name = "organization_id", nullable = false)
    open var organizationId: Long = -1,

    @Column(name = "is_active", nullable = false)
    open var isActive: Boolean = true,
) {

    override fun equals(other: Any?): Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as DepartmentUser

        if (id != other.id) return false

        return true
    }

    override fun hashCode(): Int {
        return id?.hashCode() ?: 0
    }
}
