package ru.yandex.crm.apphost.kotlin.dal.organizationmanager

import ru.yandex.crm.apphost.kotlin.dal.usermanager.OrganizationUser
import javax.persistence.CascadeType
import javax.persistence.Column
import javax.persistence.Entity
import javax.persistence.GeneratedValue
import javax.persistence.GenerationType
import javax.persistence.Id
import javax.persistence.OneToMany
import javax.persistence.Table

@Entity
@Table(
    name = "organization",
    schema = "organizationmanager"
)
open class Organization(

    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY)
    @Column(name = "id")
    open var id: Long? = null,

    @Column(name = "pool", nullable = false)
    open var pool: Long = 0,

    @Column(name = "slug", nullable = false, length = 255, unique = true)
    open var slug: String = "",

    @Column(name = "name", nullable = false, length = 255)
    open var name: String = "",
) {

    override fun equals(other: Any?): Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as Organization

        if (id != other.id) return false

        return true
    }

    override fun hashCode(): Int {
        return id?.hashCode() ?: 0
    }
}
