package ru.yandex.crm.apphost.kotlin.dal.teammanager

import org.hibernate.annotations.GenericGenerator
import ru.yandex.crm.apphost.kotlin.dal.organizationmanager.Organization
import java.io.Serializable
import java.util.UUID
import javax.persistence.CascadeType
import javax.persistence.Column
import javax.persistence.Entity
import javax.persistence.FetchType.EAGER
import javax.persistence.GeneratedValue
import javax.persistence.Id
import javax.persistence.JoinColumn
import javax.persistence.ManyToOne
import javax.persistence.OneToMany
import javax.persistence.Table

@Entity
@Table(
    name = "organization_team",
    schema = "teammanager"
)
open class OrganizationTeam(

    @Id
    @GeneratedValue(generator = "UUID")
    @GenericGenerator(name = "UUID", strategy = "org.hibernate.id.UUIDGenerator")
    @Column(name = "id", nullable = false, updatable = false)
    open var id: UUID? = null,

    @Column(name = "organization_id")
    open var organizationId: Long = 0,

    @Column(name = "security_profile_id")
    open var securityProfileId: UUID = UUID(0, 0),

    @OneToMany(mappedBy = "id.organizationTeam", cascade = [CascadeType.ALL], fetch = EAGER)
    open var names: MutableSet<OrganizationTeamName> = mutableSetOf(),

    @Column(name = "is_deleted", nullable = false)
    open var isDeleted: Boolean = false,
) : Serializable {
}
