package ru.yandex.crm.apphost.kotlin.dal.teammanager

import java.io.Serializable
import javax.persistence.Column
import javax.persistence.EmbeddedId
import javax.persistence.Entity
import javax.persistence.Table

@Entity
@Table(
    name = "organization_team_name",
    schema = "teammanager"
)
open class OrganizationTeamName(

    @EmbeddedId
    open var id: OrganizationTeamNameId? = null,

    @Column(name = "name", nullable = false, length = 255)
    open var name: String = "",
) : Serializable {

    override fun equals(other: Any?): Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as OrganizationTeamName

        if (id != other.id) return false

        return true
    }

    override fun hashCode(): Int {
        return id?.hashCode() ?: 0
    }
}
