package ru.yandex.crm.apphost.kotlin.dal.teammanager

import java.io.Serializable
import javax.persistence.Column
import javax.persistence.Embeddable
import javax.persistence.JoinColumn
import javax.persistence.ManyToOne

@Embeddable
open class OrganizationTeamNameId(

    @ManyToOne
    @JoinColumn(name = "organization_team_id", referencedColumnName = "id")
    open var organizationTeam: OrganizationTeam = OrganizationTeam(),

    @Column(name = "language_code", length = 2, nullable = false)
    open var languageCode: String = "",
) : Serializable {

    override fun equals(other: Any?): Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as OrganizationTeamNameId

        if (organizationTeam.id != other.organizationTeam.id) return false
        if (languageCode != other.languageCode) return false

        return true
    }

    override fun hashCode(): Int {
        var result = organizationTeam.id.hashCode()
        result = 31 * result + languageCode.hashCode()
        return result
    }
}
