package ru.yandex.crm.apphost.kotlin.dal.usermanager

import ru.yandex.crm.apphost.kotlin.dal.organizationmanager.Organization
import javax.persistence.CascadeType
import javax.persistence.Column
import javax.persistence.Entity
import javax.persistence.GeneratedValue
import javax.persistence.GenerationType
import javax.persistence.Id
import javax.persistence.JoinColumn
import javax.persistence.ManyToOne
import javax.persistence.Table

@Entity
@Table(
    name = "organization_user",
    schema = "usermanager"
)
open class OrganizationUser(

    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY)
    @Column(name = "organization_user_id")
    open var id: Long? = null,

    @Column(name = "organization_id")
    open var organizationId: Long = 0,

    @ManyToOne(
        cascade = [CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH]
    )
    @JoinColumn(name = "user_id", referencedColumnName = "user_id", nullable = false)
    open var user: User = User(),

    @Column(name = "is_active", nullable = false)
    open var isActive: Boolean = true,
) {

    override fun equals(other: Any?): Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as OrganizationUser

        if (id != other.id) return false

        return true
    }

    override fun hashCode(): Int {
        return id?.hashCode() ?: 0
    }
}
