package ru.yandex.crm.apphost.kotlin.dal.usermanager

import javax.persistence.*

@Entity
@Table(
    name = "user",
    schema = "usermanager"
)
open class User(

    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY)
    @Column(name = "user_id")
    open var id: Long? = null,

    @Column(name = "first_name", nullable = false, length = 255)
    open var firstName: String = "",

    @Column(name = "last_name", nullable = false, length = 255)
    open var lastName: String = "",

    @OneToMany(
        mappedBy = "user",
        cascade = [CascadeType.PERSIST, CascadeType.REFRESH, CascadeType.MERGE]
    )
    open var organizations: MutableList<OrganizationUser> = mutableListOf()
) {

    override fun equals(other: Any?): Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as User

        if (id != other.id) return false

        return true
    }

    override fun hashCode(): Int {
        return id?.hashCode() ?: 0
    }
}
