package ru.yandex.crm.apphost.kotlin.dal.usermanager

import javax.persistence.Column
import javax.persistence.Entity
import javax.persistence.GeneratedValue
import javax.persistence.GenerationType
import javax.persistence.Id
import javax.persistence.JoinColumn
import javax.persistence.OneToOne
import javax.persistence.Table

@Entity
@Table(
    name = "yandex_service",
    schema = "usermanager"
)
open class YandexService(

    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY)
    open var id: Long? = null,

    @OneToOne
    @JoinColumn(name = "user_id", referencedColumnName = "user_id")
    open var user: User = User(),

    @Column(name = "tvm_id", nullable = false, unique = true)
    open var tvmId: Long = 0,

    @Column(name = "tvm_name", length = 1000)
    open var tvmName: String? = null,
) {

    override fun equals(other: Any?): Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as YandexService

        if (id != other.id) return false

        return true
    }

    override fun hashCode(): Int {
        return id?.hashCode() ?: 0
    }
}
