package ru.yandex.crm.apphost.kotlin.dal.usermanager

import javax.persistence.Column
import javax.persistence.Entity
import javax.persistence.GeneratedValue
import javax.persistence.GenerationType
import javax.persistence.Id
import javax.persistence.JoinColumn
import javax.persistence.OneToOne
import javax.persistence.Table

@Entity
@Table(
    name = "yandex_user",
    schema = "usermanager"
)
open class YandexUser(

    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY)
    open var id: Long? = null,

    @OneToOne()
    @JoinColumn(name = "user_id", referencedColumnName = "user_id")
    open var user: User = User(),

    @Column(name = "uid", nullable = false, unique = true)
    open var uId: Long = 0,

    @Column(name = "login", length = 255)
    open var login: String? = null,
) {

    override fun equals(other: Any?): Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as YandexUser

        if (id != other.id) return false

        return true
    }

    override fun hashCode(): Int {
        return id?.hashCode() ?: 0
    }
}
